# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n
from .offer_apply_form_object_config_info import OfferApplyFormObjectConfigInfo


class OfferApplyFormObjectInfo(object):
    _types = {
        "id": str,
        "name": I18n,
        "description": I18n,
        "module_id": str,
        "is_customized": bool,
        "is_required": bool,
        "active_status": int,
        "need_approve": bool,
        "is_sensitive": bool,
        "object_type": int,
        "config": OfferApplyFormObjectConfigInfo,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.description: Optional[I18n] = None
        self.module_id: Optional[str] = None
        self.is_customized: Optional[bool] = None
        self.is_required: Optional[bool] = None
        self.active_status: Optional[int] = None
        self.need_approve: Optional[bool] = None
        self.is_sensitive: Optional[bool] = None
        self.object_type: Optional[int] = None
        self.config: Optional[OfferApplyFormObjectConfigInfo] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferApplyFormObjectInfoBuilder":
        return OfferApplyFormObjectInfoBuilder()


class OfferApplyFormObjectInfoBuilder(object):
    def __init__(self) -> None:
        self._offer_apply_form_object_info = OfferApplyFormObjectInfo()

    def id(self, id: str) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.id = id
        return self

    def name(self, name: I18n) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.name = name
        return self

    def description(self, description: I18n) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.description = description
        return self

    def module_id(self, module_id: str) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.module_id = module_id
        return self

    def is_customized(self, is_customized: bool) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.is_customized = is_customized
        return self

    def is_required(self, is_required: bool) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.is_required = is_required
        return self

    def active_status(self, active_status: int) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.active_status = active_status
        return self

    def need_approve(self, need_approve: bool) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.need_approve = need_approve
        return self

    def is_sensitive(self, is_sensitive: bool) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.is_sensitive = is_sensitive
        return self

    def object_type(self, object_type: int) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.object_type = object_type
        return self

    def config(self, config: OfferApplyFormObjectConfigInfo) -> "OfferApplyFormObjectInfoBuilder":
        self._offer_apply_form_object_info.config = config
        return self

    def build(self) -> "OfferApplyFormObjectInfo":
        return self._offer_apply_form_object_info
