# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .department import Department
from .i18n import I18n


class OfferApprovalTemplate(object):
    _types = {
        "id": str,
        "name": I18n,
        "create_time": str,
        "remark": str,
        "department_list": List[Department],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[I18n] = None
        self.create_time: Optional[str] = None
        self.remark: Optional[str] = None
        self.department_list: Optional[List[Department]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferApprovalTemplateBuilder":
        return OfferApprovalTemplateBuilder()


class OfferApprovalTemplateBuilder(object):
    def __init__(self) -> None:
        self._offer_approval_template = OfferApprovalTemplate()

    def id(self, id: str) -> "OfferApprovalTemplateBuilder":
        self._offer_approval_template.id = id
        return self

    def name(self, name: I18n) -> "OfferApprovalTemplateBuilder":
        self._offer_approval_template.name = name
        return self

    def create_time(self, create_time: str) -> "OfferApprovalTemplateBuilder":
        self._offer_approval_template.create_time = create_time
        return self

    def remark(self, remark: str) -> "OfferApprovalTemplateBuilder":
        self._offer_approval_template.remark = remark
        return self

    def department_list(self, department_list: List[Department]) -> "OfferApprovalTemplateBuilder":
        self._offer_approval_template.department_list = department_list
        return self

    def build(self) -> "OfferApprovalTemplate":
        return self._offer_approval_template
