# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .offer_basic_info import OfferBasicInfo
from .offer_customized_info import OfferCustomizedInfo
from .offer_salary_info import OfferSalaryInfo


class OfferInfo(object):
    _types = {
        "offer_id": str,
        "application_id": str,
        "schema_id": str,
        "offer_type": int,
        "basic_info": OfferBasicInfo,
        "salary_info": OfferSalaryInfo,
        "customized_info_list": List[OfferCustomizedInfo],
    }

    def __init__(self, d=None):
        self.offer_id: Optional[str] = None
        self.application_id: Optional[str] = None
        self.schema_id: Optional[str] = None
        self.offer_type: Optional[int] = None
        self.basic_info: Optional[OfferBasicInfo] = None
        self.salary_info: Optional[OfferSalaryInfo] = None
        self.customized_info_list: Optional[List[OfferCustomizedInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferInfoBuilder":
        return OfferInfoBuilder()


class OfferInfoBuilder(object):
    def __init__(self) -> None:
        self._offer_info = OfferInfo()

    def offer_id(self, offer_id: str) -> "OfferInfoBuilder":
        self._offer_info.offer_id = offer_id
        return self

    def application_id(self, application_id: str) -> "OfferInfoBuilder":
        self._offer_info.application_id = application_id
        return self

    def schema_id(self, schema_id: str) -> "OfferInfoBuilder":
        self._offer_info.schema_id = schema_id
        return self

    def offer_type(self, offer_type: int) -> "OfferInfoBuilder":
        self._offer_info.offer_type = offer_type
        return self

    def basic_info(self, basic_info: OfferBasicInfo) -> "OfferInfoBuilder":
        self._offer_info.basic_info = basic_info
        return self

    def salary_info(self, salary_info: OfferSalaryInfo) -> "OfferInfoBuilder":
        self._offer_info.salary_info = salary_info
        return self

    def customized_info_list(self, customized_info_list: List[OfferCustomizedInfo]) -> "OfferInfoBuilder":
        self._offer_info.customized_info_list = customized_info_list
        return self

    def build(self) -> "OfferInfo":
        return self._offer_info
