# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .base_bilingual_with_id import BaseBilingualWithId
from .offer_job_info import OfferJobInfo


class OfferListInfo(object):
    _types = {
        "id": str,
        "job_info": OfferJobInfo,
        "create_time": str,
        "offer_status": int,
        "offer_type": int,
        "employee_type": BaseBilingualWithId,
        "application_id": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.job_info: Optional[OfferJobInfo] = None
        self.create_time: Optional[str] = None
        self.offer_status: Optional[int] = None
        self.offer_type: Optional[int] = None
        self.employee_type: Optional[BaseBilingualWithId] = None
        self.application_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferListInfoBuilder":
        return OfferListInfoBuilder()


class OfferListInfoBuilder(object):
    def __init__(self) -> None:
        self._offer_list_info = OfferListInfo()

    def id(self, id: str) -> "OfferListInfoBuilder":
        self._offer_list_info.id = id
        return self

    def job_info(self, job_info: OfferJobInfo) -> "OfferListInfoBuilder":
        self._offer_list_info.job_info = job_info
        return self

    def create_time(self, create_time: str) -> "OfferListInfoBuilder":
        self._offer_list_info.create_time = create_time
        return self

    def offer_status(self, offer_status: int) -> "OfferListInfoBuilder":
        self._offer_list_info.offer_status = offer_status
        return self

    def offer_type(self, offer_type: int) -> "OfferListInfoBuilder":
        self._offer_list_info.offer_type = offer_type
        return self

    def employee_type(self, employee_type: BaseBilingualWithId) -> "OfferListInfoBuilder":
        self._offer_list_info.employee_type = employee_type
        return self

    def application_id(self, application_id: str) -> "OfferListInfoBuilder":
        self._offer_list_info.application_id = application_id
        return self

    def build(self) -> "OfferListInfo":
        return self._offer_list_info
