# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class OfferSalaryInfo(object):
    _types = {
        "currency": str,
        "basic_salary": str,
        "probation_salary_percentage": str,
        "award_salary_multiple": str,
        "option_shares": str,
        "quarterly_bonus": str,
        "half_year_bonus": str,
    }

    def __init__(self, d=None):
        self.currency: Optional[str] = None
        self.basic_salary: Optional[str] = None
        self.probation_salary_percentage: Optional[str] = None
        self.award_salary_multiple: Optional[str] = None
        self.option_shares: Optional[str] = None
        self.quarterly_bonus: Optional[str] = None
        self.half_year_bonus: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferSalaryInfoBuilder":
        return OfferSalaryInfoBuilder()


class OfferSalaryInfoBuilder(object):
    def __init__(self) -> None:
        self._offer_salary_info = OfferSalaryInfo()

    def currency(self, currency: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.currency = currency
        return self

    def basic_salary(self, basic_salary: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.basic_salary = basic_salary
        return self

    def probation_salary_percentage(self, probation_salary_percentage: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.probation_salary_percentage = probation_salary_percentage
        return self

    def award_salary_multiple(self, award_salary_multiple: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.award_salary_multiple = award_salary_multiple
        return self

    def option_shares(self, option_shares: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.option_shares = option_shares
        return self

    def quarterly_bonus(self, quarterly_bonus: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.quarterly_bonus = quarterly_bonus
        return self

    def half_year_bonus(self, half_year_bonus: str) -> "OfferSalaryInfoBuilder":
        self._offer_salary_info.half_year_bonus = half_year_bonus
        return self

    def build(self) -> "OfferSalaryInfo":
        return self._offer_salary_info
