# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .offer_schema_detail import OfferSchemaDetail


class OfferSchemaChild(object):
    _types = {
        "id": str,
        "scenario": int,
        "version": int,
        "object_list": List[OfferSchemaDetail],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.scenario: Optional[int] = None
        self.version: Optional[int] = None
        self.object_list: Optional[List[OfferSchemaDetail]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferSchemaChildBuilder":
        return OfferSchemaChildBuilder()


class OfferSchemaChildBuilder(object):
    def __init__(self) -> None:
        self._offer_schema_child = OfferSchemaChild()

    def id(self, id: str) -> "OfferSchemaChildBuilder":
        self._offer_schema_child.id = id
        return self

    def scenario(self, scenario: int) -> "OfferSchemaChildBuilder":
        self._offer_schema_child.scenario = scenario
        return self

    def version(self, version: int) -> "OfferSchemaChildBuilder":
        self._offer_schema_child.version = version
        return self

    def object_list(self, object_list: List[OfferSchemaDetail]) -> "OfferSchemaChildBuilder":
        self._offer_schema_child.object_list = object_list
        return self

    def build(self) -> "OfferSchemaChild":
        return self._offer_schema_child
