# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .offer_schema_detail_option import OfferSchemaDetailOption


class OfferSelectionObject(object):
    _types = {
        "schema_version": int,
        "option_list": List[OfferSchemaDetailOption],
    }

    def __init__(self, d=None):
        self.schema_version: Optional[int] = None
        self.option_list: Optional[List[OfferSchemaDetailOption]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OfferSelectionObjectBuilder":
        return OfferSelectionObjectBuilder()


class OfferSelectionObjectBuilder(object):
    def __init__(self) -> None:
        self._offer_selection_object = OfferSelectionObject()

    def schema_version(self, schema_version: int) -> "OfferSelectionObjectBuilder":
        self._offer_selection_object.schema_version = schema_version
        return self

    def option_list(self, option_list: List[OfferSchemaDetailOption]) -> "OfferSelectionObjectBuilder":
        self._offer_selection_object.option_list = option_list
        return self

    def build(self) -> "OfferSelectionObject":
        return self._offer_selection_object
