# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .ehr_import_task import EhrImportTask


class PatchEhrImportTaskRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.ehr_import_task_id: Optional[str] = None
        self.request_body: Optional[EhrImportTask] = None

    @staticmethod
    def builder() -> "PatchEhrImportTaskRequestBuilder":
        return PatchEhrImportTaskRequestBuilder()


class PatchEhrImportTaskRequestBuilder(object):

    def __init__(self) -> None:
        patch_ehr_import_task_request = PatchEhrImportTaskRequest()
        patch_ehr_import_task_request.http_method = HttpMethod.PATCH
        patch_ehr_import_task_request.uri = "/open-apis/hire/v1/ehr_import_tasks/:ehr_import_task_id"
        patch_ehr_import_task_request.token_types = {AccessTokenType.TENANT}
        self._patch_ehr_import_task_request: PatchEhrImportTaskRequest = patch_ehr_import_task_request

    def ehr_import_task_id(self, ehr_import_task_id: str) -> "PatchEhrImportTaskRequestBuilder":
        self._patch_ehr_import_task_request.ehr_import_task_id = ehr_import_task_id
        self._patch_ehr_import_task_request.paths["ehr_import_task_id"] = str(ehr_import_task_id)
        return self

    def request_body(self, request_body: EhrImportTask) -> "PatchEhrImportTaskRequestBuilder":
        self._patch_ehr_import_task_request.request_body = request_body
        self._patch_ehr_import_task_request.body = request_body
        return self

    def build(self) -> PatchEhrImportTaskRequest:
        return self._patch_ehr_import_task_request
