# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .common_address import CommonAddress
from .id_name_object import IdNameObject
from .website_job_post_customized_data import WebsiteJobPostCustomizedData


class PortalJobPost(object):
    _types = {
        "id": str,
        "title": str,
        "job_id": str,
        "job_code": str,
        "job_expire_time": str,
        "job_active_status": int,
        "job_process_type": int,
        "job_recruitment_type": IdNameObject,
        "job_department": IdNameObject,
        "job_type": IdNameObject,
        "min_job_level": IdNameObject,
        "max_job_level": IdNameObject,
        "address": CommonAddress,
        "min_salary": str,
        "max_salary": str,
        "required_degree": int,
        "experience": int,
        "headcount": int,
        "high_light_list": List[IdNameObject],
        "description": str,
        "requirement": str,
        "creator": IdNameObject,
        "create_time": str,
        "modify_time": str,
        "customized_data_list": List[WebsiteJobPostCustomizedData],
        "job_function": IdNameObject,
        "subject": IdNameObject,
        "address_list": List[CommonAddress],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.title: Optional[str] = None
        self.job_id: Optional[str] = None
        self.job_code: Optional[str] = None
        self.job_expire_time: Optional[str] = None
        self.job_active_status: Optional[int] = None
        self.job_process_type: Optional[int] = None
        self.job_recruitment_type: Optional[IdNameObject] = None
        self.job_department: Optional[IdNameObject] = None
        self.job_type: Optional[IdNameObject] = None
        self.min_job_level: Optional[IdNameObject] = None
        self.max_job_level: Optional[IdNameObject] = None
        self.address: Optional[CommonAddress] = None
        self.min_salary: Optional[str] = None
        self.max_salary: Optional[str] = None
        self.required_degree: Optional[int] = None
        self.experience: Optional[int] = None
        self.headcount: Optional[int] = None
        self.high_light_list: Optional[List[IdNameObject]] = None
        self.description: Optional[str] = None
        self.requirement: Optional[str] = None
        self.creator: Optional[IdNameObject] = None
        self.create_time: Optional[str] = None
        self.modify_time: Optional[str] = None
        self.customized_data_list: Optional[List[WebsiteJobPostCustomizedData]] = None
        self.job_function: Optional[IdNameObject] = None
        self.subject: Optional[IdNameObject] = None
        self.address_list: Optional[List[CommonAddress]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PortalJobPostBuilder":
        return PortalJobPostBuilder()


class PortalJobPostBuilder(object):
    def __init__(self) -> None:
        self._portal_job_post = PortalJobPost()

    def id(self, id: str) -> "PortalJobPostBuilder":
        self._portal_job_post.id = id
        return self

    def title(self, title: str) -> "PortalJobPostBuilder":
        self._portal_job_post.title = title
        return self

    def job_id(self, job_id: str) -> "PortalJobPostBuilder":
        self._portal_job_post.job_id = job_id
        return self

    def job_code(self, job_code: str) -> "PortalJobPostBuilder":
        self._portal_job_post.job_code = job_code
        return self

    def job_expire_time(self, job_expire_time: str) -> "PortalJobPostBuilder":
        self._portal_job_post.job_expire_time = job_expire_time
        return self

    def job_active_status(self, job_active_status: int) -> "PortalJobPostBuilder":
        self._portal_job_post.job_active_status = job_active_status
        return self

    def job_process_type(self, job_process_type: int) -> "PortalJobPostBuilder":
        self._portal_job_post.job_process_type = job_process_type
        return self

    def job_recruitment_type(self, job_recruitment_type: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.job_recruitment_type = job_recruitment_type
        return self

    def job_department(self, job_department: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.job_department = job_department
        return self

    def job_type(self, job_type: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.job_type = job_type
        return self

    def min_job_level(self, min_job_level: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.min_job_level = min_job_level
        return self

    def max_job_level(self, max_job_level: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.max_job_level = max_job_level
        return self

    def address(self, address: CommonAddress) -> "PortalJobPostBuilder":
        self._portal_job_post.address = address
        return self

    def min_salary(self, min_salary: str) -> "PortalJobPostBuilder":
        self._portal_job_post.min_salary = min_salary
        return self

    def max_salary(self, max_salary: str) -> "PortalJobPostBuilder":
        self._portal_job_post.max_salary = max_salary
        return self

    def required_degree(self, required_degree: int) -> "PortalJobPostBuilder":
        self._portal_job_post.required_degree = required_degree
        return self

    def experience(self, experience: int) -> "PortalJobPostBuilder":
        self._portal_job_post.experience = experience
        return self

    def headcount(self, headcount: int) -> "PortalJobPostBuilder":
        self._portal_job_post.headcount = headcount
        return self

    def high_light_list(self, high_light_list: List[IdNameObject]) -> "PortalJobPostBuilder":
        self._portal_job_post.high_light_list = high_light_list
        return self

    def description(self, description: str) -> "PortalJobPostBuilder":
        self._portal_job_post.description = description
        return self

    def requirement(self, requirement: str) -> "PortalJobPostBuilder":
        self._portal_job_post.requirement = requirement
        return self

    def creator(self, creator: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.creator = creator
        return self

    def create_time(self, create_time: str) -> "PortalJobPostBuilder":
        self._portal_job_post.create_time = create_time
        return self

    def modify_time(self, modify_time: str) -> "PortalJobPostBuilder":
        self._portal_job_post.modify_time = modify_time
        return self

    def customized_data_list(self, customized_data_list: List[WebsiteJobPostCustomizedData]) -> "PortalJobPostBuilder":
        self._portal_job_post.customized_data_list = customized_data_list
        return self

    def job_function(self, job_function: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.job_function = job_function
        return self

    def subject(self, subject: IdNameObject) -> "PortalJobPostBuilder":
        self._portal_job_post.subject = subject
        return self

    def address_list(self, address_list: List[CommonAddress]) -> "PortalJobPostBuilder":
        self._portal_job_post.address_list = address_list
        return self

    def build(self) -> "PortalJobPost":
        return self._portal_job_post
