# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class PreviewAttachmentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.attachment_id: Optional[str] = None

    @staticmethod
    def builder() -> "PreviewAttachmentRequestBuilder":
        return PreviewAttachmentRequestBuilder()


class PreviewAttachmentRequestBuilder(object):

    def __init__(self) -> None:
        preview_attachment_request = PreviewAttachmentRequest()
        preview_attachment_request.http_method = HttpMethod.GET
        preview_attachment_request.uri = "/open-apis/hire/v1/attachments/:attachment_id/preview"
        preview_attachment_request.token_types = {AccessTokenType.TENANT}
        self._preview_attachment_request: PreviewAttachmentRequest = preview_attachment_request

    def attachment_id(self, attachment_id: str) -> "PreviewAttachmentRequestBuilder":
        self._preview_attachment_request.attachment_id = attachment_id
        self._preview_attachment_request.paths["attachment_id"] = str(attachment_id)
        return self

    def build(self) -> PreviewAttachmentRequest:
        return self._preview_attachment_request
