# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ProjectInfo(object):
    _types = {
        "desc": str,
        "end_time": int,
        "link": str,
        "name": str,
        "role": str,
        "start_time": int,
    }

    def __init__(self, d=None):
        self.desc: Optional[str] = None
        self.end_time: Optional[int] = None
        self.link: Optional[str] = None
        self.name: Optional[str] = None
        self.role: Optional[str] = None
        self.start_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ProjectInfoBuilder":
        return ProjectInfoBuilder()


class ProjectInfoBuilder(object):
    def __init__(self) -> None:
        self._project_info = ProjectInfo()

    def desc(self, desc: str) -> "ProjectInfoBuilder":
        self._project_info.desc = desc
        return self

    def end_time(self, end_time: int) -> "ProjectInfoBuilder":
        self._project_info.end_time = end_time
        return self

    def link(self, link: str) -> "ProjectInfoBuilder":
        self._project_info.link = link
        return self

    def name(self, name: str) -> "ProjectInfoBuilder":
        self._project_info.name = name
        return self

    def role(self, role: str) -> "ProjectInfoBuilder":
        self._project_info.role = role
        return self

    def start_time(self, start_time: int) -> "ProjectInfoBuilder":
        self._project_info.start_time = start_time
        return self

    def build(self) -> "ProjectInfo":
        return self._project_info
