# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class ProviderIdNameObject(object):
    _types = {
        "provider_id": str,
        "provider_name": I18n,
    }

    def __init__(self, d=None):
        self.provider_id: Optional[str] = None
        self.provider_name: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ProviderIdNameObjectBuilder":
        return ProviderIdNameObjectBuilder()


class ProviderIdNameObjectBuilder(object):
    def __init__(self) -> None:
        self._provider_id_name_object = ProviderIdNameObject()

    def provider_id(self, provider_id: str) -> "ProviderIdNameObjectBuilder":
        self._provider_id_name_object.provider_id = provider_id
        return self

    def provider_name(self, provider_name: I18n) -> "ProviderIdNameObjectBuilder":
        self._provider_id_name_object.provider_name = provider_name
        return self

    def build(self) -> "ProviderIdNameObject":
        return self._provider_id_name_object
