# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .five_start_scoring_result import FiveStartScoringResult
from .select_option_result import SelectOptionResult


class Question(object):
    _types = {
        "question_id": str,
        "question_name": str,
        "question_en_name": str,
        "question_desc": str,
        "question_en_desc": str,
        "question_type": int,
        "is_required": bool,
        "select_option_result_list": List[SelectOptionResult],
        "five_start_scoring_result": FiveStartScoringResult,
        "description_result": str,
    }

    def __init__(self, d=None):
        self.question_id: Optional[str] = None
        self.question_name: Optional[str] = None
        self.question_en_name: Optional[str] = None
        self.question_desc: Optional[str] = None
        self.question_en_desc: Optional[str] = None
        self.question_type: Optional[int] = None
        self.is_required: Optional[bool] = None
        self.select_option_result_list: Optional[List[SelectOptionResult]] = None
        self.five_start_scoring_result: Optional[FiveStartScoringResult] = None
        self.description_result: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "QuestionBuilder":
        return QuestionBuilder()


class QuestionBuilder(object):
    def __init__(self) -> None:
        self._question = Question()

    def question_id(self, question_id: str) -> "QuestionBuilder":
        self._question.question_id = question_id
        return self

    def question_name(self, question_name: str) -> "QuestionBuilder":
        self._question.question_name = question_name
        return self

    def question_en_name(self, question_en_name: str) -> "QuestionBuilder":
        self._question.question_en_name = question_en_name
        return self

    def question_desc(self, question_desc: str) -> "QuestionBuilder":
        self._question.question_desc = question_desc
        return self

    def question_en_desc(self, question_en_desc: str) -> "QuestionBuilder":
        self._question.question_en_desc = question_en_desc
        return self

    def question_type(self, question_type: int) -> "QuestionBuilder":
        self._question.question_type = question_type
        return self

    def is_required(self, is_required: bool) -> "QuestionBuilder":
        self._question.is_required = is_required
        return self

    def select_option_result_list(self, select_option_result_list: List[SelectOptionResult]) -> "QuestionBuilder":
        self._question.select_option_result_list = select_option_result_list
        return self

    def five_start_scoring_result(self, five_start_scoring_result: FiveStartScoringResult) -> "QuestionBuilder":
        self._question.five_start_scoring_result = five_start_scoring_result
        return self

    def description_result(self, description_result: str) -> "QuestionBuilder":
        self._question.description_result = description_result
        return self

    def build(self) -> "Question":
        return self._question
