# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .reconciliation_referral_account_request_body import ReconciliationReferralAccountRequestBody


class ReconciliationReferralAccountRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[ReconciliationReferralAccountRequestBody] = None

    @staticmethod
    def builder() -> "ReconciliationReferralAccountRequestBuilder":
        return ReconciliationReferralAccountRequestBuilder()


class ReconciliationReferralAccountRequestBuilder(object):

    def __init__(self) -> None:
        reconciliation_referral_account_request = ReconciliationReferralAccountRequest()
        reconciliation_referral_account_request.http_method = HttpMethod.POST
        reconciliation_referral_account_request.uri = "/open-apis/hire/v1/referral_account/reconciliation"
        reconciliation_referral_account_request.token_types = {AccessTokenType.TENANT}
        self._reconciliation_referral_account_request: ReconciliationReferralAccountRequest = reconciliation_referral_account_request

    def request_body(self,
                     request_body: ReconciliationReferralAccountRequestBody) -> "ReconciliationReferralAccountRequestBuilder":
        self._reconciliation_referral_account_request.request_body = request_body
        self._reconciliation_referral_account_request.body = request_body
        return self

    def build(self) -> ReconciliationReferralAccountRequest:
        return self._reconciliation_referral_account_request
