# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class RecruiterJobRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.job_id: Optional[str] = None

    @staticmethod
    def builder() -> "RecruiterJobRequestBuilder":
        return RecruiterJobRequestBuilder()


class RecruiterJobRequestBuilder(object):

    def __init__(self) -> None:
        recruiter_job_request = RecruiterJobRequest()
        recruiter_job_request.http_method = HttpMethod.GET
        recruiter_job_request.uri = "/open-apis/hire/v1/jobs/:job_id/recruiter"
        recruiter_job_request.token_types = {AccessTokenType.TENANT}
        self._recruiter_job_request: RecruiterJobRequest = recruiter_job_request

    def user_id_type(self, user_id_type: str) -> "RecruiterJobRequestBuilder":
        self._recruiter_job_request.user_id_type = user_id_type
        self._recruiter_job_request.add_query("user_id_type", user_id_type)
        return self

    def job_id(self, job_id: str) -> "RecruiterJobRequestBuilder":
        self._recruiter_job_request.job_id = job_id
        self._recruiter_job_request.paths["job_id"] = str(job_id)
        return self

    def build(self) -> RecruiterJobRequest:
        return self._recruiter_job_request
