# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .id_name_object import IdNameObject


class ReferralInfo(object):
    _types = {
        "id": str,
        "application_ids": List[str],
        "create_time": str,
        "referral_user": IdNameObject,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.application_ids: Optional[List[str]] = None
        self.create_time: Optional[str] = None
        self.referral_user: Optional[IdNameObject] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReferralInfoBuilder":
        return ReferralInfoBuilder()


class ReferralInfoBuilder(object):
    def __init__(self) -> None:
        self._referral_info = ReferralInfo()

    def id(self, id: str) -> "ReferralInfoBuilder":
        self._referral_info.id = id
        return self

    def application_ids(self, application_ids: List[str]) -> "ReferralInfoBuilder":
        self._referral_info.application_ids = application_ids
        return self

    def create_time(self, create_time: str) -> "ReferralInfoBuilder":
        self._referral_info.create_time = create_time
        return self

    def referral_user(self, referral_user: IdNameObject) -> "ReferralInfoBuilder":
        self._referral_info.referral_user = referral_user
        return self

    def build(self) -> "ReferralInfo":
        return self._referral_info
