# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class RegistrationBasicInfo(object):
    _types = {
        "id": str,
        "registration_time": int,
        "download_url": str,
        "scenario": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.registration_time: Optional[int] = None
        self.download_url: Optional[str] = None
        self.scenario: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RegistrationBasicInfoBuilder":
        return RegistrationBasicInfoBuilder()


class RegistrationBasicInfoBuilder(object):
    def __init__(self) -> None:
        self._registration_basic_info = RegistrationBasicInfo()

    def id(self, id: str) -> "RegistrationBasicInfoBuilder":
        self._registration_basic_info.id = id
        return self

    def registration_time(self, registration_time: int) -> "RegistrationBasicInfoBuilder":
        self._registration_basic_info.registration_time = registration_time
        return self

    def download_url(self, download_url: str) -> "RegistrationBasicInfoBuilder":
        self._registration_basic_info.download_url = download_url
        return self

    def scenario(self, scenario: int) -> "RegistrationBasicInfoBuilder":
        self._registration_basic_info.scenario = scenario
        return self

    def build(self) -> "RegistrationBasicInfo":
        return self._registration_basic_info
