# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .site_job_city import SiteJobCity
from .site_job_recruitment_type import SiteJobRecruitmentType
from .site_job_type import SiteJobType


class SiteJobPost(object):
    _types = {
        "id": str,
        "title": str,
        "description": str,
        "requirement": str,
        "job_type_info": SiteJobType,
        "city_info": SiteJobCity,
        "recruitment_type": SiteJobRecruitmentType,
        "publish_time": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.title: Optional[str] = None
        self.description: Optional[str] = None
        self.requirement: Optional[str] = None
        self.job_type_info: Optional[SiteJobType] = None
        self.city_info: Optional[SiteJobCity] = None
        self.recruitment_type: Optional[SiteJobRecruitmentType] = None
        self.publish_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SiteJobPostBuilder":
        return SiteJobPostBuilder()


class SiteJobPostBuilder(object):
    def __init__(self) -> None:
        self._site_job_post = SiteJobPost()

    def id(self, id: str) -> "SiteJobPostBuilder":
        self._site_job_post.id = id
        return self

    def title(self, title: str) -> "SiteJobPostBuilder":
        self._site_job_post.title = title
        return self

    def description(self, description: str) -> "SiteJobPostBuilder":
        self._site_job_post.description = description
        return self

    def requirement(self, requirement: str) -> "SiteJobPostBuilder":
        self._site_job_post.requirement = requirement
        return self

    def job_type_info(self, job_type_info: SiteJobType) -> "SiteJobPostBuilder":
        self._site_job_post.job_type_info = job_type_info
        return self

    def city_info(self, city_info: SiteJobCity) -> "SiteJobPostBuilder":
        self._site_job_post.city_info = city_info
        return self

    def recruitment_type(self, recruitment_type: SiteJobRecruitmentType) -> "SiteJobPostBuilder":
        self._site_job_post.recruitment_type = recruitment_type
        return self

    def publish_time(self, publish_time: int) -> "SiteJobPostBuilder":
        self._site_job_post.publish_time = publish_time
        return self

    def build(self) -> "SiteJobPost":
        return self._site_job_post
