# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class SiteResumeCareer(object):
    _types = {
        "company": str,
        "title": str,
        "career_type": str,
        "description": str,
        "start_time": str,
        "end_time": str,
    }

    def __init__(self, d=None):
        self.company: Optional[str] = None
        self.title: Optional[str] = None
        self.career_type: Optional[str] = None
        self.description: Optional[str] = None
        self.start_time: Optional[str] = None
        self.end_time: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SiteResumeCareerBuilder":
        return SiteResumeCareerBuilder()


class SiteResumeCareerBuilder(object):
    def __init__(self) -> None:
        self._site_resume_career = SiteResumeCareer()

    def company(self, company: str) -> "SiteResumeCareerBuilder":
        self._site_resume_career.company = company
        return self

    def title(self, title: str) -> "SiteResumeCareerBuilder":
        self._site_resume_career.title = title
        return self

    def career_type(self, career_type: str) -> "SiteResumeCareerBuilder":
        self._site_resume_career.career_type = career_type
        return self

    def description(self, description: str) -> "SiteResumeCareerBuilder":
        self._site_resume_career.description = description
        return self

    def start_time(self, start_time: str) -> "SiteResumeCareerBuilder":
        self._site_resume_career.start_time = start_time
        return self

    def end_time(self, end_time: str) -> "SiteResumeCareerBuilder":
        self._site_resume_career.end_time = end_time
        return self

    def build(self) -> "SiteResumeCareer":
        return self._site_resume_career
