# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class SiteResumeWork(object):
    _types = {
        "link": str,
        "description": str,
        "site_attachment_id": str,
    }

    def __init__(self, d=None):
        self.link: Optional[str] = None
        self.description: Optional[str] = None
        self.site_attachment_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SiteResumeWorkBuilder":
        return SiteResumeWorkBuilder()


class SiteResumeWorkBuilder(object):
    def __init__(self) -> None:
        self._site_resume_work = SiteResumeWork()

    def link(self, link: str) -> "SiteResumeWorkBuilder":
        self._site_resume_work.link = link
        return self

    def description(self, description: str) -> "SiteResumeWorkBuilder":
        self._site_resume_work.description = description
        return self

    def site_attachment_id(self, site_attachment_id: str) -> "SiteResumeWorkBuilder":
        self._site_resume_work.site_attachment_id = site_attachment_id
        return self

    def build(self) -> "SiteResumeWork":
        return self._site_resume_work
