# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Store(object):
    _types = {
        "id": str,
        "name": str,
        "name_en": str,
        "department_id": str,
        "active_status": int,
        "address_id": str,
        "manager_id": str,
        "remark": str,
        "remark_en": str,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.name_en: Optional[str] = None
        self.department_id: Optional[str] = None
        self.active_status: Optional[int] = None
        self.address_id: Optional[str] = None
        self.manager_id: Optional[str] = None
        self.remark: Optional[str] = None
        self.remark_en: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "StoreBuilder":
        return StoreBuilder()


class StoreBuilder(object):
    def __init__(self) -> None:
        self._store = Store()

    def id(self, id: str) -> "StoreBuilder":
        self._store.id = id
        return self

    def name(self, name: str) -> "StoreBuilder":
        self._store.name = name
        return self

    def name_en(self, name_en: str) -> "StoreBuilder":
        self._store.name_en = name_en
        return self

    def department_id(self, department_id: str) -> "StoreBuilder":
        self._store.department_id = department_id
        return self

    def active_status(self, active_status: int) -> "StoreBuilder":
        self._store.active_status = active_status
        return self

    def address_id(self, address_id: str) -> "StoreBuilder":
        self._store.address_id = address_id
        return self

    def manager_id(self, manager_id: str) -> "StoreBuilder":
        self._store.manager_id = manager_id
        return self

    def remark(self, remark: str) -> "StoreBuilder":
        self._store.remark = remark
        return self

    def remark_en(self, remark_en: str) -> "StoreBuilder":
        self._store.remark_en = remark_en
        return self

    def build(self) -> "Store":
        return self._store
