# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .registration_basic_info import RegistrationBasicInfo
from .talent_award_info import TalentAwardInfo
from .talent_basic_info import TalentBasicInfo
from .talent_career_info import TalentCareerInfo
from .talent_customized_data import TalentCustomizedData
from .talent_education_info import TalentEducationInfo
from .talent_interview_registration_simple import TalentInterviewRegistrationSimple
from .talent_language_info import TalentLanguageInfo
from .talent_project_info import TalentProjectInfo
from .talent_resume_source import TalentResumeSource
from .talent_sns_info import TalentSnsInfo
from .talent_works_info import TalentWorksInfo


class Talent(object):
    _types = {
        "id": str,
        "is_in_agency_period": bool,
        "is_onboarded": bool,
        "basic_info": TalentBasicInfo,
        "education_list": List[TalentEducationInfo],
        "career_list": List[TalentCareerInfo],
        "project_list": List[TalentProjectInfo],
        "works_list": List[TalentWorksInfo],
        "award_list": List[TalentAwardInfo],
        "language_list": List[TalentLanguageInfo],
        "sns_list": List[TalentSnsInfo],
        "resume_source_list": List[TalentResumeSource],
        "interview_registration_list": List[TalentInterviewRegistrationSimple],
        "registration_list": List[RegistrationBasicInfo],
        "resume_attachment_id_list": List[str],
        "customized_data_list": List[TalentCustomizedData],
        "top_degree": int,
        "first_degree": int,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.is_in_agency_period: Optional[bool] = None
        self.is_onboarded: Optional[bool] = None
        self.basic_info: Optional[TalentBasicInfo] = None
        self.education_list: Optional[List[TalentEducationInfo]] = None
        self.career_list: Optional[List[TalentCareerInfo]] = None
        self.project_list: Optional[List[TalentProjectInfo]] = None
        self.works_list: Optional[List[TalentWorksInfo]] = None
        self.award_list: Optional[List[TalentAwardInfo]] = None
        self.language_list: Optional[List[TalentLanguageInfo]] = None
        self.sns_list: Optional[List[TalentSnsInfo]] = None
        self.resume_source_list: Optional[List[TalentResumeSource]] = None
        self.interview_registration_list: Optional[List[TalentInterviewRegistrationSimple]] = None
        self.registration_list: Optional[List[RegistrationBasicInfo]] = None
        self.resume_attachment_id_list: Optional[List[str]] = None
        self.customized_data_list: Optional[List[TalentCustomizedData]] = None
        self.top_degree: Optional[int] = None
        self.first_degree: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentBuilder":
        return TalentBuilder()


class TalentBuilder(object):
    def __init__(self) -> None:
        self._talent = Talent()

    def id(self, id: str) -> "TalentBuilder":
        self._talent.id = id
        return self

    def is_in_agency_period(self, is_in_agency_period: bool) -> "TalentBuilder":
        self._talent.is_in_agency_period = is_in_agency_period
        return self

    def is_onboarded(self, is_onboarded: bool) -> "TalentBuilder":
        self._talent.is_onboarded = is_onboarded
        return self

    def basic_info(self, basic_info: TalentBasicInfo) -> "TalentBuilder":
        self._talent.basic_info = basic_info
        return self

    def education_list(self, education_list: List[TalentEducationInfo]) -> "TalentBuilder":
        self._talent.education_list = education_list
        return self

    def career_list(self, career_list: List[TalentCareerInfo]) -> "TalentBuilder":
        self._talent.career_list = career_list
        return self

    def project_list(self, project_list: List[TalentProjectInfo]) -> "TalentBuilder":
        self._talent.project_list = project_list
        return self

    def works_list(self, works_list: List[TalentWorksInfo]) -> "TalentBuilder":
        self._talent.works_list = works_list
        return self

    def award_list(self, award_list: List[TalentAwardInfo]) -> "TalentBuilder":
        self._talent.award_list = award_list
        return self

    def language_list(self, language_list: List[TalentLanguageInfo]) -> "TalentBuilder":
        self._talent.language_list = language_list
        return self

    def sns_list(self, sns_list: List[TalentSnsInfo]) -> "TalentBuilder":
        self._talent.sns_list = sns_list
        return self

    def resume_source_list(self, resume_source_list: List[TalentResumeSource]) -> "TalentBuilder":
        self._talent.resume_source_list = resume_source_list
        return self

    def interview_registration_list(self, interview_registration_list: List[
        TalentInterviewRegistrationSimple]) -> "TalentBuilder":
        self._talent.interview_registration_list = interview_registration_list
        return self

    def registration_list(self, registration_list: List[RegistrationBasicInfo]) -> "TalentBuilder":
        self._talent.registration_list = registration_list
        return self

    def resume_attachment_id_list(self, resume_attachment_id_list: List[str]) -> "TalentBuilder":
        self._talent.resume_attachment_id_list = resume_attachment_id_list
        return self

    def customized_data_list(self, customized_data_list: List[TalentCustomizedData]) -> "TalentBuilder":
        self._talent.customized_data_list = customized_data_list
        return self

    def top_degree(self, top_degree: int) -> "TalentBuilder":
        self._talent.top_degree = top_degree
        return self

    def first_degree(self, first_degree: int) -> "TalentBuilder":
        self._talent.first_degree = first_degree
        return self

    def build(self) -> "Talent":
        return self._talent
