# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TalentBatchInfo(object):
    _types = {
        "talent_id": str,
        "mobile_code": str,
        "mobile_number": str,
        "email": str,
        "identification_type": int,
        "identification_number": str,
    }

    def __init__(self, d=None):
        self.talent_id: Optional[str] = None
        self.mobile_code: Optional[str] = None
        self.mobile_number: Optional[str] = None
        self.email: Optional[str] = None
        self.identification_type: Optional[int] = None
        self.identification_number: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentBatchInfoBuilder":
        return TalentBatchInfoBuilder()


class TalentBatchInfoBuilder(object):
    def __init__(self) -> None:
        self._talent_batch_info = TalentBatchInfo()

    def talent_id(self, talent_id: str) -> "TalentBatchInfoBuilder":
        self._talent_batch_info.talent_id = talent_id
        return self

    def mobile_code(self, mobile_code: str) -> "TalentBatchInfoBuilder":
        self._talent_batch_info.mobile_code = mobile_code
        return self

    def mobile_number(self, mobile_number: str) -> "TalentBatchInfoBuilder":
        self._talent_batch_info.mobile_number = mobile_number
        return self

    def email(self, email: str) -> "TalentBatchInfoBuilder":
        self._talent_batch_info.email = email
        return self

    def identification_type(self, identification_type: int) -> "TalentBatchInfoBuilder":
        self._talent_batch_info.identification_type = identification_type
        return self

    def identification_number(self, identification_number: str) -> "TalentBatchInfoBuilder":
        self._talent_batch_info.identification_number = identification_number
        return self

    def build(self) -> "TalentBatchInfo":
        return self._talent_batch_info
