# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .talent_customized_data_object_value import TalentCustomizedDataObjectValue


class TalentCombinedWorkInfo(object):
    _types = {
        "id": str,
        "link": str,
        "desc": str,
        "attachment_id": str,
        "customized_data": List[TalentCustomizedDataObjectValue],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.link: Optional[str] = None
        self.desc: Optional[str] = None
        self.attachment_id: Optional[str] = None
        self.customized_data: Optional[List[TalentCustomizedDataObjectValue]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentCombinedWorkInfoBuilder":
        return TalentCombinedWorkInfoBuilder()


class TalentCombinedWorkInfoBuilder(object):
    def __init__(self) -> None:
        self._talent_combined_work_info = TalentCombinedWorkInfo()

    def id(self, id: str) -> "TalentCombinedWorkInfoBuilder":
        self._talent_combined_work_info.id = id
        return self

    def link(self, link: str) -> "TalentCombinedWorkInfoBuilder":
        self._talent_combined_work_info.link = link
        return self

    def desc(self, desc: str) -> "TalentCombinedWorkInfoBuilder":
        self._talent_combined_work_info.desc = desc
        return self

    def attachment_id(self, attachment_id: str) -> "TalentCombinedWorkInfoBuilder":
        self._talent_combined_work_info.attachment_id = attachment_id
        return self

    def customized_data(self,
                        customized_data: List[TalentCustomizedDataObjectValue]) -> "TalentCombinedWorkInfoBuilder":
        self._talent_combined_work_info.customized_data = customized_data
        return self

    def build(self) -> "TalentCombinedWorkInfo":
        return self._talent_combined_work_info
