# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .talent_customized_data_child import TalentCustomizedDataChild


class TalentCompetitionInfo(object):
    _types = {
        "id": str,
        "name": str,
        "desc": str,
        "customized_data_list": List[TalentCustomizedDataChild],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.desc: Optional[str] = None
        self.customized_data_list: Optional[List[TalentCustomizedDataChild]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentCompetitionInfoBuilder":
        return TalentCompetitionInfoBuilder()


class TalentCompetitionInfoBuilder(object):
    def __init__(self) -> None:
        self._talent_competition_info = TalentCompetitionInfo()

    def id(self, id: str) -> "TalentCompetitionInfoBuilder":
        self._talent_competition_info.id = id
        return self

    def name(self, name: str) -> "TalentCompetitionInfoBuilder":
        self._talent_competition_info.name = name
        return self

    def desc(self, desc: str) -> "TalentCompetitionInfoBuilder":
        self._talent_competition_info.desc = desc
        return self

    def customized_data_list(self,
                             customized_data_list: List[TalentCustomizedDataChild]) -> "TalentCompetitionInfoBuilder":
        self._talent_competition_info.customized_data_list = customized_data_list
        return self

    def build(self) -> "TalentCompetitionInfo":
        return self._talent_competition_info
