# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TalentCustomizedAttachment(object):
    _types = {
        "file_id": str,
        "name": str,
        "content_type": str,
        "file_size": int,
    }

    def __init__(self, d=None):
        self.file_id: Optional[str] = None
        self.name: Optional[str] = None
        self.content_type: Optional[str] = None
        self.file_size: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentCustomizedAttachmentBuilder":
        return TalentCustomizedAttachmentBuilder()


class TalentCustomizedAttachmentBuilder(object):
    def __init__(self) -> None:
        self._talent_customized_attachment = TalentCustomizedAttachment()

    def file_id(self, file_id: str) -> "TalentCustomizedAttachmentBuilder":
        self._talent_customized_attachment.file_id = file_id
        return self

    def name(self, name: str) -> "TalentCustomizedAttachmentBuilder":
        self._talent_customized_attachment.name = name
        return self

    def content_type(self, content_type: str) -> "TalentCustomizedAttachmentBuilder":
        self._talent_customized_attachment.content_type = content_type
        return self

    def file_size(self, file_size: int) -> "TalentCustomizedAttachmentBuilder":
        self._talent_customized_attachment.file_size = file_size
        return self

    def build(self) -> "TalentCustomizedAttachment":
        return self._talent_customized_attachment
