# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .talent_customized_data_object_value_child import TalentCustomizedDataObjectValueChild


class TalentCustomizedDataObjectValue(object):
    _types = {
        "object_id": str,
        "children": List[TalentCustomizedDataObjectValueChild],
    }

    def __init__(self, d=None):
        self.object_id: Optional[str] = None
        self.children: Optional[List[TalentCustomizedDataObjectValueChild]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentCustomizedDataObjectValueBuilder":
        return TalentCustomizedDataObjectValueBuilder()


class TalentCustomizedDataObjectValueBuilder(object):
    def __init__(self) -> None:
        self._talent_customized_data_object_value = TalentCustomizedDataObjectValue()

    def object_id(self, object_id: str) -> "TalentCustomizedDataObjectValueBuilder":
        self._talent_customized_data_object_value.object_id = object_id
        return self

    def children(self,
                 children: List[TalentCustomizedDataObjectValueChild]) -> "TalentCustomizedDataObjectValueBuilder":
        self._talent_customized_data_object_value.children = children
        return self

    def build(self) -> "TalentCustomizedDataObjectValue":
        return self._talent_customized_data_object_value
