# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n import I18n


class TalentCustomizedOption(object):
    _types = {
        "key": str,
        "name": I18n,
    }

    def __init__(self, d=None):
        self.key: Optional[str] = None
        self.name: Optional[I18n] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentCustomizedOptionBuilder":
        return TalentCustomizedOptionBuilder()


class TalentCustomizedOptionBuilder(object):
    def __init__(self) -> None:
        self._talent_customized_option = TalentCustomizedOption()

    def key(self, key: str) -> "TalentCustomizedOptionBuilder":
        self._talent_customized_option.key = key
        return self

    def name(self, name: I18n) -> "TalentCustomizedOptionBuilder":
        self._talent_customized_option.name = name
        return self

    def build(self) -> "TalentCustomizedOption":
        return self._talent_customized_option
