# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .talent_customized_attachment import TalentCustomizedAttachment
from .talent_customized_option import TalentCustomizedOption
from .talent_customized_time_range import TalentCustomizedTimeRange


class TalentCustomizedValue(object):
    _types = {
        "content": str,
        "option": TalentCustomizedOption,
        "option_list": List[TalentCustomizedOption],
        "time_range": TalentCustomizedTimeRange,
        "time": str,
        "number": str,
        "customized_attachment": List[TalentCustomizedAttachment],
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.option: Optional[TalentCustomizedOption] = None
        self.option_list: Optional[List[TalentCustomizedOption]] = None
        self.time_range: Optional[TalentCustomizedTimeRange] = None
        self.time: Optional[str] = None
        self.number: Optional[str] = None
        self.customized_attachment: Optional[List[TalentCustomizedAttachment]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentCustomizedValueBuilder":
        return TalentCustomizedValueBuilder()


class TalentCustomizedValueBuilder(object):
    def __init__(self) -> None:
        self._talent_customized_value = TalentCustomizedValue()

    def content(self, content: str) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.content = content
        return self

    def option(self, option: TalentCustomizedOption) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.option = option
        return self

    def option_list(self, option_list: List[TalentCustomizedOption]) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.option_list = option_list
        return self

    def time_range(self, time_range: TalentCustomizedTimeRange) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.time_range = time_range
        return self

    def time(self, time: str) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.time = time
        return self

    def number(self, number: str) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.number = number
        return self

    def customized_attachment(self, customized_attachment: List[
        TalentCustomizedAttachment]) -> "TalentCustomizedValueBuilder":
        self._talent_customized_value.customized_attachment = customized_attachment
        return self

    def build(self) -> "TalentCustomizedValue":
        return self._talent_customized_value
