# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class TalentInternshipInfo(object):
    _types = {
        "id": str,
        "company": str,
        "desc": str,
        "end_time": int,
        "start_time": int,
        "title": str,
        "tag_list": List[int],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.company: Optional[str] = None
        self.desc: Optional[str] = None
        self.end_time: Optional[int] = None
        self.start_time: Optional[int] = None
        self.title: Optional[str] = None
        self.tag_list: Optional[List[int]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentInternshipInfoBuilder":
        return TalentInternshipInfoBuilder()


class TalentInternshipInfoBuilder(object):
    def __init__(self) -> None:
        self._talent_internship_info = TalentInternshipInfo()

    def id(self, id: str) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.id = id
        return self

    def company(self, company: str) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.company = company
        return self

    def desc(self, desc: str) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.desc = desc
        return self

    def end_time(self, end_time: int) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.end_time = end_time
        return self

    def start_time(self, start_time: int) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.start_time = start_time
        return self

    def title(self, title: str) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.title = title
        return self

    def tag_list(self, tag_list: List[int]) -> "TalentInternshipInfoBuilder":
        self._talent_internship_info.tag_list = tag_list
        return self

    def build(self) -> "TalentInternshipInfo":
        return self._talent_internship_info
