# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .interview_extend import InterviewExtend


class TalentInterview(object):
    _types = {
        "application_id": str,
        "interview_list": List[InterviewExtend],
    }

    def __init__(self, d=None):
        self.application_id: Optional[str] = None
        self.interview_list: Optional[List[InterviewExtend]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentInterviewBuilder":
        return TalentInterviewBuilder()


class TalentInterviewBuilder(object):
    def __init__(self) -> None:
        self._talent_interview = TalentInterview()

    def application_id(self, application_id: str) -> "TalentInterviewBuilder":
        self._talent_interview.application_id = application_id
        return self

    def interview_list(self, interview_list: List[InterviewExtend]) -> "TalentInterviewBuilder":
        self._talent_interview.interview_list = interview_list
        return self

    def build(self) -> "TalentInterview":
        return self._talent_interview
