# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class TalentNationality(object):
    _types = {
        "nationality_code": str,
        "zh_name": str,
        "en_name": str,
    }

    def __init__(self, d=None):
        self.nationality_code: Optional[str] = None
        self.zh_name: Optional[str] = None
        self.en_name: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentNationalityBuilder":
        return TalentNationalityBuilder()


class TalentNationalityBuilder(object):
    def __init__(self) -> None:
        self._talent_nationality = TalentNationality()

    def nationality_code(self, nationality_code: str) -> "TalentNationalityBuilder":
        self._talent_nationality.nationality_code = nationality_code
        return self

    def zh_name(self, zh_name: str) -> "TalentNationalityBuilder":
        self._talent_nationality.zh_name = zh_name
        return self

    def en_name(self, en_name: str) -> "TalentNationalityBuilder":
        self._talent_nationality.en_name = en_name
        return self

    def build(self) -> "TalentNationality":
        return self._talent_nationality
