# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n
from .talent_schema_option import TalentSchemaOption


class TalentSchemaChildObject(object):
    _types = {
        "id": str,
        "active_status": int,
        "is_customized": bool,
        "name": I18n,
        "option_list": List[TalentSchemaOption],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.active_status: Optional[int] = None
        self.is_customized: Optional[bool] = None
        self.name: Optional[I18n] = None
        self.option_list: Optional[List[TalentSchemaOption]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentSchemaChildObjectBuilder":
        return TalentSchemaChildObjectBuilder()


class TalentSchemaChildObjectBuilder(object):
    def __init__(self) -> None:
        self._talent_schema_child_object = TalentSchemaChildObject()

    def id(self, id: str) -> "TalentSchemaChildObjectBuilder":
        self._talent_schema_child_object.id = id
        return self

    def active_status(self, active_status: int) -> "TalentSchemaChildObjectBuilder":
        self._talent_schema_child_object.active_status = active_status
        return self

    def is_customized(self, is_customized: bool) -> "TalentSchemaChildObjectBuilder":
        self._talent_schema_child_object.is_customized = is_customized
        return self

    def name(self, name: I18n) -> "TalentSchemaChildObjectBuilder":
        self._talent_schema_child_object.name = name
        return self

    def option_list(self, option_list: List[TalentSchemaOption]) -> "TalentSchemaChildObjectBuilder":
        self._talent_schema_child_object.option_list = option_list
        return self

    def build(self) -> "TalentSchemaChildObject":
        return self._talent_schema_child_object
