# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .talent_customized_data_child import TalentCustomizedDataChild


class TalentSnsInfo(object):
    _types = {
        "id": str,
        "sns_type": int,
        "link": str,
        "customized_data_list": List[TalentCustomizedDataChild],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.sns_type: Optional[int] = None
        self.link: Optional[str] = None
        self.customized_data_list: Optional[List[TalentCustomizedDataChild]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentSnsInfoBuilder":
        return TalentSnsInfoBuilder()


class TalentSnsInfoBuilder(object):
    def __init__(self) -> None:
        self._talent_sns_info = TalentSnsInfo()

    def id(self, id: str) -> "TalentSnsInfoBuilder":
        self._talent_sns_info.id = id
        return self

    def sns_type(self, sns_type: int) -> "TalentSnsInfoBuilder":
        self._talent_sns_info.sns_type = sns_type
        return self

    def link(self, link: str) -> "TalentSnsInfoBuilder":
        self._talent_sns_info.link = link
        return self

    def customized_data_list(self, customized_data_list: List[TalentCustomizedDataChild]) -> "TalentSnsInfoBuilder":
        self._talent_sns_info.customized_data_list = customized_data_list
        return self

    def build(self) -> "TalentSnsInfo":
        return self._talent_sns_info
