# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .talent_customized_data_child import TalentCustomizedDataChild


class TalentWorksInfo(object):
    _types = {
        "id": str,
        "link": str,
        "desc": str,
        "name": str,
        "customized_data_list": List[TalentCustomizedDataChild],
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.link: Optional[str] = None
        self.desc: Optional[str] = None
        self.name: Optional[str] = None
        self.customized_data_list: Optional[List[TalentCustomizedDataChild]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TalentWorksInfoBuilder":
        return TalentWorksInfoBuilder()


class TalentWorksInfoBuilder(object):
    def __init__(self) -> None:
        self._talent_works_info = TalentWorksInfo()

    def id(self, id: str) -> "TalentWorksInfoBuilder":
        self._talent_works_info.id = id
        return self

    def link(self, link: str) -> "TalentWorksInfoBuilder":
        self._talent_works_info.link = link
        return self

    def desc(self, desc: str) -> "TalentWorksInfoBuilder":
        self._talent_works_info.desc = desc
        return self

    def name(self, name: str) -> "TalentWorksInfoBuilder":
        self._talent_works_info.name = name
        return self

    def customized_data_list(self, customized_data_list: List[TalentCustomizedDataChild]) -> "TalentWorksInfoBuilder":
        self._talent_works_info.customized_data_list = customized_data_list
        return self

    def build(self) -> "TalentWorksInfo":
        return self._talent_works_info
