# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .terminate_application_request_body import TerminateApplicationRequestBody


class TerminateApplicationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.application_id: Optional[str] = None
        self.request_body: Optional[TerminateApplicationRequestBody] = None

    @staticmethod
    def builder() -> "TerminateApplicationRequestBuilder":
        return TerminateApplicationRequestBuilder()


class TerminateApplicationRequestBuilder(object):

    def __init__(self) -> None:
        terminate_application_request = TerminateApplicationRequest()
        terminate_application_request.http_method = HttpMethod.POST
        terminate_application_request.uri = "/open-apis/hire/v1/applications/:application_id/terminate"
        terminate_application_request.token_types = {AccessTokenType.TENANT}
        self._terminate_application_request: TerminateApplicationRequest = terminate_application_request

    def application_id(self, application_id: str) -> "TerminateApplicationRequestBuilder":
        self._terminate_application_request.application_id = application_id
        self._terminate_application_request.paths["application_id"] = str(application_id)
        return self

    def request_body(self, request_body: TerminateApplicationRequestBody) -> "TerminateApplicationRequestBuilder":
        self._terminate_application_request.request_body = request_body
        self._terminate_application_request.body = request_body
        return self

    def build(self) -> TerminateApplicationRequest:
        return self._terminate_application_request
