# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n
from .test_result_detail import TestResultDetail
from .test_schedule import TestSchedule


class Test(object):
    _types = {
        "test_id": str,
        "application_id": str,
        "test_paper_id": str,
        "test_paper_name": str,
        "test_paper_source_id": str,
        "test_paper_source_name": I18n,
        "reply_status": int,
        "test_status": int,
        "test_schedule": TestSchedule,
        "test_complete_time": str,
        "report_url_list": List[str],
        "result_detail_list": List[TestResultDetail],
        "result_upload_time": str,
        "score": str,
        "score_submit_time": str,
        "reviewer": str,
        "created_at": str,
    }

    def __init__(self, d=None):
        self.test_id: Optional[str] = None
        self.application_id: Optional[str] = None
        self.test_paper_id: Optional[str] = None
        self.test_paper_name: Optional[str] = None
        self.test_paper_source_id: Optional[str] = None
        self.test_paper_source_name: Optional[I18n] = None
        self.reply_status: Optional[int] = None
        self.test_status: Optional[int] = None
        self.test_schedule: Optional[TestSchedule] = None
        self.test_complete_time: Optional[str] = None
        self.report_url_list: Optional[List[str]] = None
        self.result_detail_list: Optional[List[TestResultDetail]] = None
        self.result_upload_time: Optional[str] = None
        self.score: Optional[str] = None
        self.score_submit_time: Optional[str] = None
        self.reviewer: Optional[str] = None
        self.created_at: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TestBuilder":
        return TestBuilder()


class TestBuilder(object):
    def __init__(self) -> None:
        self._test = Test()

    def test_id(self, test_id: str) -> "TestBuilder":
        self._test.test_id = test_id
        return self

    def application_id(self, application_id: str) -> "TestBuilder":
        self._test.application_id = application_id
        return self

    def test_paper_id(self, test_paper_id: str) -> "TestBuilder":
        self._test.test_paper_id = test_paper_id
        return self

    def test_paper_name(self, test_paper_name: str) -> "TestBuilder":
        self._test.test_paper_name = test_paper_name
        return self

    def test_paper_source_id(self, test_paper_source_id: str) -> "TestBuilder":
        self._test.test_paper_source_id = test_paper_source_id
        return self

    def test_paper_source_name(self, test_paper_source_name: I18n) -> "TestBuilder":
        self._test.test_paper_source_name = test_paper_source_name
        return self

    def reply_status(self, reply_status: int) -> "TestBuilder":
        self._test.reply_status = reply_status
        return self

    def test_status(self, test_status: int) -> "TestBuilder":
        self._test.test_status = test_status
        return self

    def test_schedule(self, test_schedule: TestSchedule) -> "TestBuilder":
        self._test.test_schedule = test_schedule
        return self

    def test_complete_time(self, test_complete_time: str) -> "TestBuilder":
        self._test.test_complete_time = test_complete_time
        return self

    def report_url_list(self, report_url_list: List[str]) -> "TestBuilder":
        self._test.report_url_list = report_url_list
        return self

    def result_detail_list(self, result_detail_list: List[TestResultDetail]) -> "TestBuilder":
        self._test.result_detail_list = result_detail_list
        return self

    def result_upload_time(self, result_upload_time: str) -> "TestBuilder":
        self._test.result_upload_time = result_upload_time
        return self

    def score(self, score: str) -> "TestBuilder":
        self._test.score = score
        return self

    def score_submit_time(self, score_submit_time: str) -> "TestBuilder":
        self._test.score_submit_time = score_submit_time
        return self

    def reviewer(self, reviewer: str) -> "TestBuilder":
        self._test.reviewer = reviewer
        return self

    def created_at(self, created_at: str) -> "TestBuilder":
        self._test.created_at = created_at
        return self

    def build(self) -> "Test":
        return self._test
