# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .todo_common import TodoCommon


class Todo(object):
    _types = {
        "evaluation": TodoCommon,
        "offer": TodoCommon,
        "exam": TodoCommon,
        "interview": TodoCommon,
    }

    def __init__(self, d=None):
        self.evaluation: Optional[TodoCommon] = None
        self.offer: Optional[TodoCommon] = None
        self.exam: Optional[TodoCommon] = None
        self.interview: Optional[TodoCommon] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TodoBuilder":
        return TodoBuilder()


class TodoBuilder(object):
    def __init__(self) -> None:
        self._todo = Todo()

    def evaluation(self, evaluation: TodoCommon) -> "TodoBuilder":
        self._todo.evaluation = evaluation
        return self

    def offer(self, offer: TodoCommon) -> "TodoBuilder":
        self._todo.offer = offer
        return self

    def exam(self, exam: TodoCommon) -> "TodoBuilder":
        self._todo.exam = exam
        return self

    def interview(self, interview: TodoCommon) -> "TodoBuilder":
        self._todo.interview = interview
        return self

    def build(self) -> "Todo":
        return self._todo
