# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .bonus_amount import BonusAmount


class TradeDetail(object):
    _types = {
        "account_id": str,
        "total_recharge_reward_info": BonusAmount,
    }

    def __init__(self, d=None):
        self.account_id: Optional[str] = None
        self.total_recharge_reward_info: Optional[BonusAmount] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TradeDetailBuilder":
        return TradeDetailBuilder()


class TradeDetailBuilder(object):
    def __init__(self) -> None:
        self._trade_detail = TradeDetail()

    def account_id(self, account_id: str) -> "TradeDetailBuilder":
        self._trade_detail.account_id = account_id
        return self

    def total_recharge_reward_info(self, total_recharge_reward_info: BonusAmount) -> "TradeDetailBuilder":
        self._trade_detail.total_recharge_reward_info = total_recharge_reward_info
        return self

    def build(self) -> "TradeDetail":
        return self._trade_detail
