# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .job_config import JobConfig


class UpdateConfigJobRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.job_id: Optional[str] = None
        self.request_body: Optional[JobConfig] = None

    @staticmethod
    def builder() -> "UpdateConfigJobRequestBuilder":
        return UpdateConfigJobRequestBuilder()


class UpdateConfigJobRequestBuilder(object):

    def __init__(self) -> None:
        update_config_job_request = UpdateConfigJobRequest()
        update_config_job_request.http_method = HttpMethod.POST
        update_config_job_request.uri = "/open-apis/hire/v1/jobs/:job_id/update_config"
        update_config_job_request.token_types = {AccessTokenType.TENANT}
        self._update_config_job_request: UpdateConfigJobRequest = update_config_job_request

    def user_id_type(self, user_id_type: str) -> "UpdateConfigJobRequestBuilder":
        self._update_config_job_request.user_id_type = user_id_type
        self._update_config_job_request.add_query("user_id_type", user_id_type)
        return self

    def job_id(self, job_id: str) -> "UpdateConfigJobRequestBuilder":
        self._update_config_job_request.job_id = job_id
        self._update_config_job_request.paths["job_id"] = str(job_id)
        return self

    def request_body(self, request_body: JobConfig) -> "UpdateConfigJobRequestBuilder":
        self._update_config_job_request.request_body = request_body
        self._update_config_job_request.body = request_body
        return self

    def build(self) -> UpdateConfigJobRequest:
        return self._update_config_job_request
