# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .external_application import ExternalApplication


class UpdateExternalApplicationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.external_application_id: Optional[str] = None
        self.request_body: Optional[ExternalApplication] = None

    @staticmethod
    def builder() -> "UpdateExternalApplicationRequestBuilder":
        return UpdateExternalApplicationRequestBuilder()


class UpdateExternalApplicationRequestBuilder(object):

    def __init__(self) -> None:
        update_external_application_request = UpdateExternalApplicationRequest()
        update_external_application_request.http_method = HttpMethod.PUT
        update_external_application_request.uri = "/open-apis/hire/v1/external_applications/:external_application_id"
        update_external_application_request.token_types = {AccessTokenType.TENANT}
        self._update_external_application_request: UpdateExternalApplicationRequest = update_external_application_request

    def external_application_id(self, external_application_id: str) -> "UpdateExternalApplicationRequestBuilder":
        self._update_external_application_request.external_application_id = external_application_id
        self._update_external_application_request.paths["external_application_id"] = str(external_application_id)
        return self

    def request_body(self, request_body: ExternalApplication) -> "UpdateExternalApplicationRequestBuilder":
        self._update_external_application_request.request_body = request_body
        self._update_external_application_request.body = request_body
        return self

    def build(self) -> UpdateExternalApplicationRequest:
        return self._update_external_application_request
