# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .offer_basic_info import OfferBasicInfo
from .offer_customized_info import OfferCustomizedInfo
from .offer_salary_info import OfferSalaryInfo


class UpdateOfferResponseBody(object):
    _types = {
        "offer_id": str,
        "schema_id": str,
        "basic_info": OfferBasicInfo,
        "salary_info": OfferSalaryInfo,
        "customized_info_list": List[OfferCustomizedInfo],
    }

    def __init__(self, d=None):
        self.offer_id: Optional[str] = None
        self.schema_id: Optional[str] = None
        self.basic_info: Optional[OfferBasicInfo] = None
        self.salary_info: Optional[OfferSalaryInfo] = None
        self.customized_info_list: Optional[List[OfferCustomizedInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UpdateOfferResponseBodyBuilder":
        return UpdateOfferResponseBodyBuilder()


class UpdateOfferResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._update_offer_response_body = UpdateOfferResponseBody()

    def offer_id(self, offer_id: str) -> "UpdateOfferResponseBodyBuilder":
        self._update_offer_response_body.offer_id = offer_id
        return self

    def schema_id(self, schema_id: str) -> "UpdateOfferResponseBodyBuilder":
        self._update_offer_response_body.schema_id = schema_id
        return self

    def basic_info(self, basic_info: OfferBasicInfo) -> "UpdateOfferResponseBodyBuilder":
        self._update_offer_response_body.basic_info = basic_info
        return self

    def salary_info(self, salary_info: OfferSalaryInfo) -> "UpdateOfferResponseBodyBuilder":
        self._update_offer_response_body.salary_info = salary_info
        return self

    def customized_info_list(self, customized_info_list: List[OfferCustomizedInfo]) -> "UpdateOfferResponseBodyBuilder":
        self._update_offer_response_body.customized_info_list = customized_info_list
        return self

    def build(self) -> "UpdateOfferResponseBody":
        return self._update_offer_response_body
