# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .eco_background_check_report_file import EcoBackgroundCheckReportFile


class UpdateResultEcoBackgroundCheckRequestBody(object):
    _types = {
        "background_check_id": str,
        "result": str,
        "result_time": str,
        "report_file_list": List[EcoBackgroundCheckReportFile],
    }

    def __init__(self, d=None):
        self.background_check_id: Optional[str] = None
        self.result: Optional[str] = None
        self.result_time: Optional[str] = None
        self.report_file_list: Optional[List[EcoBackgroundCheckReportFile]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UpdateResultEcoBackgroundCheckRequestBodyBuilder":
        return UpdateResultEcoBackgroundCheckRequestBodyBuilder()


class UpdateResultEcoBackgroundCheckRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._update_result_eco_background_check_request_body = UpdateResultEcoBackgroundCheckRequestBody()

    def background_check_id(self, background_check_id: str) -> "UpdateResultEcoBackgroundCheckRequestBodyBuilder":
        self._update_result_eco_background_check_request_body.background_check_id = background_check_id
        return self

    def result(self, result: str) -> "UpdateResultEcoBackgroundCheckRequestBodyBuilder":
        self._update_result_eco_background_check_request_body.result = result
        return self

    def result_time(self, result_time: str) -> "UpdateResultEcoBackgroundCheckRequestBodyBuilder":
        self._update_result_eco_background_check_request_body.result_time = result_time
        return self

    def report_file_list(self, report_file_list: List[
        EcoBackgroundCheckReportFile]) -> "UpdateResultEcoBackgroundCheckRequestBodyBuilder":
        self._update_result_eco_background_check_request_body.report_file_list = report_file_list
        return self

    def build(self) -> "UpdateResultEcoBackgroundCheckRequestBody":
        return self._update_result_eco_background_check_request_body
