# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .eco_exam_result import EcoExamResult


class UpdateResultEcoExamRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.exam_id: Optional[str] = None
        self.request_body: Optional[EcoExamResult] = None

    @staticmethod
    def builder() -> "UpdateResultEcoExamRequestBuilder":
        return UpdateResultEcoExamRequestBuilder()


class UpdateResultEcoExamRequestBuilder(object):

    def __init__(self) -> None:
        update_result_eco_exam_request = UpdateResultEcoExamRequest()
        update_result_eco_exam_request.http_method = HttpMethod.POST
        update_result_eco_exam_request.uri = "/open-apis/hire/v1/eco_exams/:exam_id/update_result"
        update_result_eco_exam_request.token_types = {AccessTokenType.TENANT}
        self._update_result_eco_exam_request: UpdateResultEcoExamRequest = update_result_eco_exam_request

    def exam_id(self, exam_id: str) -> "UpdateResultEcoExamRequestBuilder":
        self._update_result_eco_exam_request.exam_id = exam_id
        self._update_result_eco_exam_request.paths["exam_id"] = str(exam_id)
        return self

    def request_body(self, request_body: EcoExamResult) -> "UpdateResultEcoExamRequestBuilder":
        self._update_result_eco_exam_request.request_body = request_body
        self._update_result_eco_exam_request.body = request_body
        return self

    def build(self) -> UpdateResultEcoExamRequest:
        return self._update_result_eco_exam_request
