# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .website_delivery_customized_data import WebsiteDeliveryCustomizedData
from .website_delivery_identification import WebsiteDeliveryIdentification


class WebsiteDeliveryBasicInfo(object):
    _types = {
        "nationality_id": str,
        "start_work_time": int,
        "current_home_address": str,
        "hometown_city_code": str,
        "mobile_country_code": str,
        "identification": WebsiteDeliveryIdentification,
        "marital_status": int,
        "mobile": str,
        "current_city_code": str,
        "experience_years": int,
        "gender": int,
        "birthday": int,
        "name": str,
        "preferred_city_code_list": List[str],
        "resume_source_id": str,
        "age": int,
        "customized_data": List[WebsiteDeliveryCustomizedData],
        "email": str,
    }

    def __init__(self, d=None):
        self.nationality_id: Optional[str] = None
        self.start_work_time: Optional[int] = None
        self.current_home_address: Optional[str] = None
        self.hometown_city_code: Optional[str] = None
        self.mobile_country_code: Optional[str] = None
        self.identification: Optional[WebsiteDeliveryIdentification] = None
        self.marital_status: Optional[int] = None
        self.mobile: Optional[str] = None
        self.current_city_code: Optional[str] = None
        self.experience_years: Optional[int] = None
        self.gender: Optional[int] = None
        self.birthday: Optional[int] = None
        self.name: Optional[str] = None
        self.preferred_city_code_list: Optional[List[str]] = None
        self.resume_source_id: Optional[str] = None
        self.age: Optional[int] = None
        self.customized_data: Optional[List[WebsiteDeliveryCustomizedData]] = None
        self.email: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteDeliveryBasicInfoBuilder":
        return WebsiteDeliveryBasicInfoBuilder()


class WebsiteDeliveryBasicInfoBuilder(object):
    def __init__(self) -> None:
        self._website_delivery_basic_info = WebsiteDeliveryBasicInfo()

    def nationality_id(self, nationality_id: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.nationality_id = nationality_id
        return self

    def start_work_time(self, start_work_time: int) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.start_work_time = start_work_time
        return self

    def current_home_address(self, current_home_address: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.current_home_address = current_home_address
        return self

    def hometown_city_code(self, hometown_city_code: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.hometown_city_code = hometown_city_code
        return self

    def mobile_country_code(self, mobile_country_code: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.mobile_country_code = mobile_country_code
        return self

    def identification(self, identification: WebsiteDeliveryIdentification) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.identification = identification
        return self

    def marital_status(self, marital_status: int) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.marital_status = marital_status
        return self

    def mobile(self, mobile: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.mobile = mobile
        return self

    def current_city_code(self, current_city_code: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.current_city_code = current_city_code
        return self

    def experience_years(self, experience_years: int) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.experience_years = experience_years
        return self

    def gender(self, gender: int) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.gender = gender
        return self

    def birthday(self, birthday: int) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.birthday = birthday
        return self

    def name(self, name: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.name = name
        return self

    def preferred_city_code_list(self, preferred_city_code_list: List[str]) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.preferred_city_code_list = preferred_city_code_list
        return self

    def resume_source_id(self, resume_source_id: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.resume_source_id = resume_source_id
        return self

    def age(self, age: int) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.age = age
        return self

    def customized_data(self,
                        customized_data: List[WebsiteDeliveryCustomizedData]) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.customized_data = customized_data
        return self

    def email(self, email: str) -> "WebsiteDeliveryBasicInfoBuilder":
        self._website_delivery_basic_info.email = email
        return self

    def build(self) -> "WebsiteDeliveryBasicInfo":
        return self._website_delivery_basic_info
