# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .website_delivery_customized_data import WebsiteDeliveryCustomizedData


class WebsiteDeliveryCareer(object):
    _types = {
        "desc": str,
        "end_time": int,
        "start_time": int,
        "title": str,
        "company": str,
        "customized_data": List[WebsiteDeliveryCustomizedData],
    }

    def __init__(self, d=None):
        self.desc: Optional[str] = None
        self.end_time: Optional[int] = None
        self.start_time: Optional[int] = None
        self.title: Optional[str] = None
        self.company: Optional[str] = None
        self.customized_data: Optional[List[WebsiteDeliveryCustomizedData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteDeliveryCareerBuilder":
        return WebsiteDeliveryCareerBuilder()


class WebsiteDeliveryCareerBuilder(object):
    def __init__(self) -> None:
        self._website_delivery_career = WebsiteDeliveryCareer()

    def desc(self, desc: str) -> "WebsiteDeliveryCareerBuilder":
        self._website_delivery_career.desc = desc
        return self

    def end_time(self, end_time: int) -> "WebsiteDeliveryCareerBuilder":
        self._website_delivery_career.end_time = end_time
        return self

    def start_time(self, start_time: int) -> "WebsiteDeliveryCareerBuilder":
        self._website_delivery_career.start_time = start_time
        return self

    def title(self, title: str) -> "WebsiteDeliveryCareerBuilder":
        self._website_delivery_career.title = title
        return self

    def company(self, company: str) -> "WebsiteDeliveryCareerBuilder":
        self._website_delivery_career.company = company
        return self

    def customized_data(self, customized_data: List[WebsiteDeliveryCustomizedData]) -> "WebsiteDeliveryCareerBuilder":
        self._website_delivery_career.customized_data = customized_data
        return self

    def build(self) -> "WebsiteDeliveryCareer":
        return self._website_delivery_career
