# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .website_delivery_customized_data import WebsiteDeliveryCustomizedData


class WebsiteDeliveryEducation(object):
    _types = {
        "education_type": int,
        "end_time": int,
        "end_time_v2": int,
        "field_of_study": str,
        "school": str,
        "start_time": int,
        "academic_ranking": int,
        "customized_data": List[WebsiteDeliveryCustomizedData],
        "degree": int,
    }

    def __init__(self, d=None):
        self.education_type: Optional[int] = None
        self.end_time: Optional[int] = None
        self.end_time_v2: Optional[int] = None
        self.field_of_study: Optional[str] = None
        self.school: Optional[str] = None
        self.start_time: Optional[int] = None
        self.academic_ranking: Optional[int] = None
        self.customized_data: Optional[List[WebsiteDeliveryCustomizedData]] = None
        self.degree: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteDeliveryEducationBuilder":
        return WebsiteDeliveryEducationBuilder()


class WebsiteDeliveryEducationBuilder(object):
    def __init__(self) -> None:
        self._website_delivery_education = WebsiteDeliveryEducation()

    def education_type(self, education_type: int) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.education_type = education_type
        return self

    def end_time(self, end_time: int) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.end_time = end_time
        return self

    def end_time_v2(self, end_time_v2: int) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.end_time_v2 = end_time_v2
        return self

    def field_of_study(self, field_of_study: str) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.field_of_study = field_of_study
        return self

    def school(self, school: str) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.school = school
        return self

    def start_time(self, start_time: int) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.start_time = start_time
        return self

    def academic_ranking(self, academic_ranking: int) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.academic_ranking = academic_ranking
        return self

    def customized_data(self,
                        customized_data: List[WebsiteDeliveryCustomizedData]) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.customized_data = customized_data
        return self

    def degree(self, degree: int) -> "WebsiteDeliveryEducationBuilder":
        self._website_delivery_education.degree = degree
        return self

    def build(self) -> "WebsiteDeliveryEducation":
        return self._website_delivery_education
