# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .website_delivery_customized_data import WebsiteDeliveryCustomizedData


class WebsiteDeliveryLanguage(object):
    _types = {
        "customized_data": List[WebsiteDeliveryCustomizedData],
        "language": int,
        "proficiency": int,
    }

    def __init__(self, d=None):
        self.customized_data: Optional[List[WebsiteDeliveryCustomizedData]] = None
        self.language: Optional[int] = None
        self.proficiency: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteDeliveryLanguageBuilder":
        return WebsiteDeliveryLanguageBuilder()


class WebsiteDeliveryLanguageBuilder(object):
    def __init__(self) -> None:
        self._website_delivery_language = WebsiteDeliveryLanguage()

    def customized_data(self, customized_data: List[WebsiteDeliveryCustomizedData]) -> "WebsiteDeliveryLanguageBuilder":
        self._website_delivery_language.customized_data = customized_data
        return self

    def language(self, language: int) -> "WebsiteDeliveryLanguageBuilder":
        self._website_delivery_language.language = language
        return self

    def proficiency(self, proficiency: int) -> "WebsiteDeliveryLanguageBuilder":
        self._website_delivery_language.proficiency = proficiency
        return self

    def build(self) -> "WebsiteDeliveryLanguage":
        return self._website_delivery_language
