# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .website_delivery_customized_data import WebsiteDeliveryCustomizedData
from .website_delivery_works_attachment import WebsiteDeliveryWorksAttachment


class WebsiteDeliveryWorks(object):
    _types = {
        "desc": str,
        "link": str,
        "attachment": WebsiteDeliveryWorksAttachment,
        "customized_data": List[WebsiteDeliveryCustomizedData],
    }

    def __init__(self, d=None):
        self.desc: Optional[str] = None
        self.link: Optional[str] = None
        self.attachment: Optional[WebsiteDeliveryWorksAttachment] = None
        self.customized_data: Optional[List[WebsiteDeliveryCustomizedData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteDeliveryWorksBuilder":
        return WebsiteDeliveryWorksBuilder()


class WebsiteDeliveryWorksBuilder(object):
    def __init__(self) -> None:
        self._website_delivery_works = WebsiteDeliveryWorks()

    def desc(self, desc: str) -> "WebsiteDeliveryWorksBuilder":
        self._website_delivery_works.desc = desc
        return self

    def link(self, link: str) -> "WebsiteDeliveryWorksBuilder":
        self._website_delivery_works.link = link
        return self

    def attachment(self, attachment: WebsiteDeliveryWorksAttachment) -> "WebsiteDeliveryWorksBuilder":
        self._website_delivery_works.attachment = attachment
        return self

    def customized_data(self, customized_data: List[WebsiteDeliveryCustomizedData]) -> "WebsiteDeliveryWorksBuilder":
        self._website_delivery_works.customized_data = customized_data
        return self

    def build(self) -> "WebsiteDeliveryWorks":
        return self._website_delivery_works
