# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .website_job_post_customized_option import WebsiteJobPostCustomizedOption
from .website_job_post_customized_time_range import WebsiteJobPostCustomizedTimeRange


class WebsiteJobPostCustomizedValue(object):
    _types = {
        "content": str,
        "option": WebsiteJobPostCustomizedOption,
        "option_list": List[WebsiteJobPostCustomizedOption],
        "time_range": WebsiteJobPostCustomizedTimeRange,
        "time": str,
        "number": str,
    }

    def __init__(self, d=None):
        self.content: Optional[str] = None
        self.option: Optional[WebsiteJobPostCustomizedOption] = None
        self.option_list: Optional[List[WebsiteJobPostCustomizedOption]] = None
        self.time_range: Optional[WebsiteJobPostCustomizedTimeRange] = None
        self.time: Optional[str] = None
        self.number: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WebsiteJobPostCustomizedValueBuilder":
        return WebsiteJobPostCustomizedValueBuilder()


class WebsiteJobPostCustomizedValueBuilder(object):
    def __init__(self) -> None:
        self._website_job_post_customized_value = WebsiteJobPostCustomizedValue()

    def content(self, content: str) -> "WebsiteJobPostCustomizedValueBuilder":
        self._website_job_post_customized_value.content = content
        return self

    def option(self, option: WebsiteJobPostCustomizedOption) -> "WebsiteJobPostCustomizedValueBuilder":
        self._website_job_post_customized_value.option = option
        return self

    def option_list(self, option_list: List[WebsiteJobPostCustomizedOption]) -> "WebsiteJobPostCustomizedValueBuilder":
        self._website_job_post_customized_value.option_list = option_list
        return self

    def time_range(self, time_range: WebsiteJobPostCustomizedTimeRange) -> "WebsiteJobPostCustomizedValueBuilder":
        self._website_job_post_customized_value.time_range = time_range
        return self

    def time(self, time: str) -> "WebsiteJobPostCustomizedValueBuilder":
        self._website_job_post_customized_value.time = time
        return self

    def number(self, number: str) -> "WebsiteJobPostCustomizedValueBuilder":
        self._website_job_post_customized_value.number = number
        return self

    def build(self) -> "WebsiteJobPostCustomizedValue":
        return self._website_job_post_customized_value
